# 📋 উপস্থিতি ট্র্যাকার (Attendance Tracker)
**Raw PHP + MySQL | Mobile-Friendly | Camera + GPS**

---

## ✅ ফিচার সমূহ
- 📱 সম্পূর্ণ মোবাইল ফ্রেন্ডলি ডিজাইন
- 📷 সামনে ও পিছনের ক্যামেরা দিয়ে ছবি তোলা
- 🗺️ GPS লোকেশন + Google Maps লিংক
- ✅ চেক ইন / চেক আউট সিস্টেম
- 👥 Admin Panel - সব কর্মচারীর উপস্থিতি দেখুন
- 📊 CSV Export
- 🔑 কর্মচারী যোগ/নিষ্ক্রিয়/পাসওয়ার্ড রিসেট
- ⏰ দেরিতে আসার স্বয়ংক্রিয় চিহ্নিতকরণ (সকাল ৯টার পরে)

---

## 🚀 ইন্সটলেশন গাইড

### ধাপ ১: ফাইল আপলোড
সব ফাইল আপনার সার্ভারের `public_html/attendance/` ফোল্ডারে আপলোড করুন।

### ধাপ ২: ডেটাবেস তৈরি
1. phpMyAdmin বা MySQL CLI তে যান
2. `database.sql` ফাইলটি import করুন:
   ```
   mysql -u root -p < database.sql
   ```

### ধাপ ৩: Config আপডেট করুন
`config.php` ফাইলে আপনার তথ্য দিন:
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'আপনার_mysql_username');
define('DB_PASS', 'আপনার_mysql_password');
define('DB_NAME', 'attendance_db');
define('APP_URL', 'https://yourdomain.com/attendance');
```

### ধাপ ৪: ফোল্ডার Permission
```bash
chmod 755 uploads/
chmod 755 uploads/photos/
```

### ধাপ ৫: ব্রাউজার থেকে খুলুন
`https://yourdomain.com/attendance/`

---

## 🔑 ডিফল্ট লগইন তথ্য

| ভূমিকা | ID/Email | পাসওয়ার্ড |
|--------|----------|------------|
| Admin | admin@company.com | admin123 |
| Employee | EMP001 | 123456 |
| Employee | EMP002 | 123456 |

> ⚠️ প্রথম লগইনের পরে পাসওয়ার্ড পরিবর্তন করুন!

---

## 📁 ফাইল স্ট্রাকচার
```
attendance/
├── index.php              # লগইন পেজ
├── dashboard.php          # কর্মচারী ড্যাশবোর্ড
├── admin.php              # Admin - উপস্থিতি দেখুন
├── admin_employees.php    # Admin - কর্মচারী ব্যবস্থাপনা
├── export.php             # CSV Export
├── logout.php             # লগআউট
├── config.php             # ডেটাবেস কনফিগ
├── database.sql           # ডেটাবেস schema
├── api/
│   └── attendance.php     # Check-in/out API
└── uploads/
    └── photos/            # ছবি সংরক্ষণ
```

---

## 🔧 লোকাল ডেভেলপমেন্ট (XAMPP/WAMP)
1. XAMPP চালু করুন (Apache + MySQL)
2. `htdocs/attendance/` তে ফাইল রাখুন
3. `http://localhost/attendance/` তে খুলুন
4. phpMyAdmin থেকে database.sql import করুন

---

## 📱 মোবাইলে Test করার উপায়
Camera ও GPS কাজ করার জন্য **HTTPS** দরকার।
Local test এর জন্য: `ngrok http 80` ব্যবহার করুন।

---

## ⚙️ কাস্টমাইজেশন
- দেরির সময় পরিবর্তন: `api/attendance.php` এ `$check_in_hour > 9` পরিবর্তন করুন
- কোম্পানির নাম: `config.php` এ `APP_NAME` পরিবর্তন করুন
