<?php
require_once 'config.php';
requireAdmin();

$db = getDB();
$today = date('Y-m-d');

// Filters
$filter_date = $_GET['date'] ?? $today;
$filter_dept = $_GET['dept'] ?? '';
$filter_emp = $_GET['emp'] ?? '';

// Get departments
$depts = $db->query("SELECT DISTINCT department FROM employees WHERE status='active' ORDER BY department")->fetchAll();

// Get attendance for selected date
$query = "SELECT a.*, e.name, e.employee_id AS emp_code, e.department, e.profile_photo
          FROM attendance a
          JOIN employees e ON a.employee_id = e.id
          WHERE a.date = ?";
$params = [$filter_date];

if ($filter_dept) { $query .= " AND e.department = ?"; $params[] = $filter_dept; }
if ($filter_emp) { $query .= " AND (e.name LIKE ? OR e.employee_id LIKE ?)"; $params[] = "%$filter_emp%"; $params[] = "%$filter_emp%"; }
$query .= " ORDER BY a.check_in_time ASC";

$stmt = $db->prepare($query);
$stmt->execute($params);
$attendances = $stmt->fetchAll();

// Stats for today
$stmt_stats = $db->prepare("
    SELECT 
        COUNT(DISTINCT e.id) as total_emp,
        SUM(CASE WHEN a.id IS NOT NULL THEN 1 ELSE 0 END) as present,
        SUM(CASE WHEN a.status='late' THEN 1 ELSE 0 END) as late,
        SUM(CASE WHEN a.check_out_time IS NOT NULL THEN 1 ELSE 0 END) as checked_out
    FROM employees e
    LEFT JOIN attendance a ON e.id = a.employee_id AND a.date = ?
    WHERE e.status = 'active' AND e.role = 'employee'
");
$stmt_stats->execute([$filter_date]);
$stats = $stmt_stats->fetch();
$absent = $stats['total_emp'] - $stats['present'];
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - উপস্থিতি ট্র্যাকার</title>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { margin:0; padding:0; box-sizing:border-box; }
        :root {
            --primary:#1a6b3a; --primary-light:#2d9e5c; --bg:#0a1f12;
            --surface:#0f2d1a; --surface2:#1a3d24; --text:#e8f5e9;
            --text-muted:#81c784; --border:#2d6b3a; --accent:#f4c430;
        }
        body { font-family:'Hind Siliguri',sans-serif; background:var(--bg); color:var(--text); min-height:100vh; }
        
        .header { background:linear-gradient(135deg,#0f4525,var(--surface)); padding:16px 20px; display:flex; justify-content:space-between; align-items:center; border-bottom:1px solid var(--border); position:sticky; top:0; z-index:100; }
        .header h1 { font-size:20px; }
        .header p { font-size:12px; color:var(--text-muted); }
        
        .nav-tabs { display:flex; gap:8px; padding:16px 20px 0; overflow-x:auto; }
        .nav-tab { padding:10px 20px; border-radius:12px 12px 0 0; border:1px solid var(--border); background:var(--surface); color:var(--text-muted); text-decoration:none; font-size:14px; white-space:nowrap; }
        .nav-tab.active { background:var(--primary); color:white; border-color:var(--primary); }
        
        .content { padding:20px; max-width:1200px; margin:0 auto; }
        
        .stats-grid { display:grid; grid-template-columns:repeat(2,1fr); gap:12px; margin-bottom:20px; }
        @media(min-width:600px) { .stats-grid { grid-template-columns:repeat(4,1fr); } }
        
        .stat-card { background:var(--surface); border:1px solid var(--border); border-radius:16px; padding:16px; text-align:center; }
        .stat-num { font-size:32px; font-weight:700; }
        .stat-num.green { color:#66bb6a; }
        .stat-num.red { color:#ef5350; }
        .stat-num.orange { color:#ff7043; }
        .stat-num.blue { color:#42a5f5; }
        .stat-label { font-size:12px; color:var(--text-muted); margin-top:4px; }
        
        .filter-card { background:var(--surface); border:1px solid var(--border); border-radius:16px; padding:16px; margin-bottom:20px; }
        .filter-row { display:flex; gap:10px; flex-wrap:wrap; }
        .filter-row input, .filter-row select {
            flex:1; min-width:140px; background:var(--surface2); border:1px solid var(--border);
            border-radius:10px; padding:10px 14px; color:var(--text); font-family:'Hind Siliguri',sans-serif; font-size:14px; outline:none;
        }
        .btn-filter { padding:10px 20px; background:var(--primary); color:white; border:none; border-radius:10px; font-family:'Hind Siliguri',sans-serif; font-size:14px; cursor:pointer; }
        .btn-filter:hover { background:var(--primary-light); }
        
        .table-wrap { background:var(--surface); border:1px solid var(--border); border-radius:16px; overflow:hidden; }
        
        .att-table { width:100%; border-collapse:collapse; }
        .att-table th { background:var(--surface2); padding:12px 16px; text-align:left; font-size:13px; color:var(--text-muted); font-weight:600; border-bottom:1px solid var(--border); }
        .att-table td { padding:12px 16px; font-size:13px; border-bottom:1px solid rgba(45,107,58,0.2); vertical-align:middle; }
        .att-table tr:last-child td { border-bottom:none; }
        .att-table tr:hover td { background:rgba(26,107,58,0.05); }
        
        .emp-info { display:flex; align-items:center; gap:10px; }
        .emp-avatar { width:36px; height:36px; border-radius:10px; background:var(--primary); display:flex; align-items:center; justify-content:center; font-size:16px; flex-shrink:0; }
        .emp-name { font-weight:600; font-size:14px; }
        .emp-dept { font-size:11px; color:var(--text-muted); }
        
        .badge { padding:4px 10px; border-radius:20px; font-size:11px; font-weight:600; }
        .badge-present { background:rgba(102,187,106,0.2); color:#66bb6a; }
        .badge-late { background:rgba(255,112,67,0.2); color:#ff7043; }
        .badge-absent { background:rgba(239,83,80,0.15); color:#ef9a9a; }
        .badge-out { background:rgba(66,165,245,0.2); color:#42a5f5; }
        
        .photo-thumb { width:40px; height:40px; border-radius:8px; object-fit:cover; cursor:pointer; border:2px solid var(--border); }
        .no-photo { width:40px; height:40px; border-radius:8px; background:var(--surface2); display:flex; align-items:center; justify-content:center; color:var(--text-muted); font-size:16px; }
        
        .map-btn { color:var(--primary-light); text-decoration:none; font-size:12px; display:inline-flex; align-items:center; gap:4px; }
        
        .logout-btn { background:rgba(239,83,80,0.15); border:1px solid rgba(239,83,80,0.3); color:#ef9a9a; padding:8px 14px; border-radius:10px; font-family:'Hind Siliguri',sans-serif; font-size:13px; cursor:pointer; text-decoration:none; }
        
        .mobile-card { display:none; }
        @media(max-width:768px) {
            .att-table { display:none; }
            .mobile-card { display:block; }
        }
        
        .mob-att-item { background:var(--surface); border:1px solid var(--border); border-radius:14px; padding:14px; margin-bottom:10px; }
        .mob-header { display:flex; justify-content:space-between; margin-bottom:10px; }
        .mob-times { display:grid; grid-template-columns:1fr 1fr; gap:8px; }
        .mob-time-box { background:var(--surface2); border-radius:10px; padding:10px; text-align:center; }
        .mob-time-label { font-size:11px; color:var(--text-muted); }
        .mob-time-val { font-size:16px; font-weight:600; margin-top:4px; }
        .mob-photos { display:flex; gap:8px; margin-top:10px; }
        
        /* Photo modal */
        .modal { display:none; position:fixed; inset:0; background:rgba(0,0,0,0.85); z-index:999; align-items:center; justify-content:center; padding:20px; }
        .modal.show { display:flex; }
        .modal img { max-width:100%; max-height:80vh; border-radius:16px; }
        .modal-close { position:absolute; top:20px; right:20px; background:rgba(255,255,255,0.1); border:none; color:white; width:40px; height:40px; border-radius:50%; font-size:20px; cursor:pointer; }

        .export-btn { padding:10px 20px; background:rgba(244,196,48,0.15); border:1px solid rgba(244,196,48,0.3); color:#f4c430; border-radius:10px; font-family:'Hind Siliguri',sans-serif; font-size:14px; cursor:pointer; text-decoration:none; }
    </style>
</head>
<body>

<div class="modal" id="photoModal" onclick="closeModal()">
    <button class="modal-close">✕</button>
    <img id="modalImg" src="" alt="">
</div>

<div class="header">
    <div>
        <h1>⚙️ Admin Panel</h1>
        <p>উপস্থিতি ব্যবস্থাপনা সিস্টেম</p>
    </div>
    <div style="display:flex;gap:10px;align-items:center">
        <a href="admin_employees.php" style="color:var(--text-muted);text-decoration:none;font-size:13px">👥 কর্মচারী</a>
        <a href="logout.php" class="logout-btn">🚪 লগআউট</a>
    </div>
</div>

<div class="content">

    <!-- Stats -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-num green"><?= $stats['present'] ?></div>
            <div class="stat-label">✅ উপস্থিত</div>
        </div>
        <div class="stat-card">
            <div class="stat-num red"><?= $absent ?></div>
            <div class="stat-label">❌ অনুপস্থিত</div>
        </div>
        <div class="stat-card">
            <div class="stat-num orange"><?= $stats['late'] ?></div>
            <div class="stat-label">⏰ দেরিতে এসেছে</div>
        </div>
        <div class="stat-card">
            <div class="stat-num blue"><?= $stats['checked_out'] ?></div>
            <div class="stat-label">🏠 চেক আউট</div>
        </div>
    </div>

    <!-- Filters -->
    <div class="filter-card">
        <form method="GET" action="admin.php">
            <div class="filter-row">
                <input type="date" name="date" value="<?= $filter_date ?>">
                <select name="dept">
                    <option value="">সব বিভাগ</option>
                    <?php foreach ($depts as $d): ?>
                    <option value="<?= $d['department'] ?>" <?= $filter_dept === $d['department'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($d['department']) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
                <input type="text" name="emp" placeholder="কর্মচারী খুঁজুন..." value="<?= htmlspecialchars($filter_emp) ?>">
                <button type="submit" class="btn-filter">🔍 খুঁজুন</button>
                <a href="export.php?date=<?= $filter_date ?>&dept=<?= $filter_dept ?>" class="export-btn">📊 Export CSV</a>
            </div>
        </form>
    </div>

    <!-- Desktop Table -->
    <div class="table-wrap">
        <table class="att-table">
            <thead>
                <tr>
                    <th>কর্মচারী</th>
                    <th>স্ট্যাটাস</th>
                    <th>চেক ইন</th>
                    <th>ছবি (ইন)</th>
                    <th>লোকেশন (ইন)</th>
                    <th>চেক আউট</th>
                    <th>ছবি (আউট)</th>
                    <th>লোকেশন (আউট)</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($attendances)): ?>
                <tr><td colspan="8" style="text-align:center;padding:40px;color:var(--text-muted)">এই তারিখে কোনো উপস্থিতি নেই</td></tr>
                <?php else: ?>
                <?php foreach ($attendances as $a): ?>
                <tr>
                    <td>
                        <div class="emp-info">
                            <div class="emp-avatar">👤</div>
                            <div>
                                <div class="emp-name"><?= htmlspecialchars($a['name']) ?></div>
                                <div class="emp-dept"><?= htmlspecialchars($a['emp_code']) ?> • <?= htmlspecialchars($a['department']) ?></div>
                            </div>
                        </div>
                    </td>
                    <td>
                        <span class="badge badge-<?= $a['status'] ?>">
                            <?= $a['status'] === 'present' ? '✅ উপস্থিত' : ($a['status'] === 'late' ? '⏰ দেরি' : '½ আধা') ?>
                        </span>
                        <?php if ($a['check_out_time']): ?>
                        <br><span class="badge badge-out" style="margin-top:4px;display:inline-block">🏠 আউট</span>
                        <?php endif; ?>
                    </td>
                    <td><?= formatTime($a['check_in_time']) ?></td>
                    <td>
                        <?php if ($a['check_in_photo']): ?>
                        <img src="uploads/photos/<?= $a['check_in_photo'] ?>" class="photo-thumb" onclick="showPhoto(this.src)">
                        <?php else: ?><div class="no-photo">📷</div><?php endif; ?>
                    </td>
                    <td>
                        <?php if ($a['check_in_lat']): ?>
                        <a href="https://maps.google.com/?q=<?= $a['check_in_lat'] ?>,<?= $a['check_in_lng'] ?>" target="_blank" class="map-btn">🗺️ ম্যাপ</a>
                        <br><small style="color:var(--text-muted);font-size:10px"><?= substr($a['check_in_address'] ?? '', 0, 30) ?>...</small>
                        <?php else: ?><span style="color:var(--text-muted)">—</span><?php endif; ?>
                    </td>
                    <td><?= $a['check_out_time'] ? formatTime($a['check_out_time']) : '—' ?></td>
                    <td>
                        <?php if ($a['check_out_photo']): ?>
                        <img src="uploads/photos/<?= $a['check_out_photo'] ?>" class="photo-thumb" onclick="showPhoto(this.src)">
                        <?php else: ?><div class="no-photo">📷</div><?php endif; ?>
                    </td>
                    <td>
                        <?php if ($a['check_out_lat']): ?>
                        <a href="https://maps.google.com/?q=<?= $a['check_out_lat'] ?>,<?= $a['check_out_lng'] ?>" target="_blank" class="map-btn">🗺️ ম্যাপ</a>
                        <?php else: ?><span style="color:var(--text-muted)">—</span><?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>

        <!-- Mobile Cards -->
        <div class="mobile-card" style="padding:12px">
            <?php foreach ($attendances as $a): ?>
            <div class="mob-att-item">
                <div class="mob-header">
                    <div>
                        <div style="font-weight:600"><?= htmlspecialchars($a['name']) ?></div>
                        <div style="font-size:12px;color:var(--text-muted)"><?= htmlspecialchars($a['emp_code']) ?> • <?= htmlspecialchars($a['department']) ?></div>
                    </div>
                    <span class="badge badge-<?= $a['status'] ?>">
                        <?= $a['status'] === 'present' ? '✅' : ($a['status'] === 'late' ? '⏰ দেরি' : '½') ?>
                    </span>
                </div>
                <div class="mob-times">
                    <div class="mob-time-box">
                        <div class="mob-time-label">✅ চেক ইন</div>
                        <div class="mob-time-val" style="color:#66bb6a"><?= formatTime($a['check_in_time']) ?></div>
                        <?php if ($a['check_in_lat']): ?>
                        <a href="https://maps.google.com/?q=<?= $a['check_in_lat'] ?>,<?= $a['check_in_lng'] ?>" target="_blank" class="map-btn" style="justify-content:center">🗺️</a>
                        <?php endif; ?>
                    </div>
                    <div class="mob-time-box">
                        <div class="mob-time-label">🔴 চেক আউট</div>
                        <div class="mob-time-val" style="color:#ff7043"><?= $a['check_out_time'] ? formatTime($a['check_out_time']) : '--' ?></div>
                        <?php if ($a['check_out_lat']): ?>
                        <a href="https://maps.google.com/?q=<?= $a['check_out_lat'] ?>,<?= $a['check_out_lng'] ?>" target="_blank" class="map-btn" style="justify-content:center">🗺️</a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="mob-photos">
                    <?php if ($a['check_in_photo']): ?>
                    <img src="uploads/photos/<?= $a['check_in_photo'] ?>" class="photo-thumb" onclick="showPhoto(this.src)" title="চেক ইন ছবি">
                    <?php endif; ?>
                    <?php if ($a['check_out_photo']): ?>
                    <img src="uploads/photos/<?= $a['check_out_photo'] ?>" class="photo-thumb" onclick="showPhoto(this.src)" title="চেক আউট ছবি">
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
            <?php if (empty($attendances)): ?>
            <p style="text-align:center;padding:30px;color:var(--text-muted)">এই তারিখে কোনো উপস্থিতি নেই</p>
            <?php endif; ?>
        </div>
    </div>

</div>

<script>
function showPhoto(src) {
    document.getElementById('modalImg').src = src;
    document.getElementById('photoModal').classList.add('show');
}
function closeModal() {
    document.getElementById('photoModal').classList.remove('show');
}
</script>
</body>
</html>
