<?php
require_once 'config.php';
requireAdmin();

$db = getDB();
$msg = '';
$error = '';

// Add employee
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['action'] === 'add') {
    $name = sanitize($_POST['name']);
    $emp_id = sanitize($_POST['emp_id']);
    $email = sanitize($_POST['email']);
    $password = $_POST['password'];
    $department = sanitize($_POST['department']);
    $phone = sanitize($_POST['phone'] ?? '');
    $role = $_POST['role'] === 'admin' ? 'admin' : 'employee';

    if ($name && $emp_id && $email && $password) {
        try {
            $hashed = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $db->prepare("INSERT INTO employees (name, employee_id, email, password, department, phone, role) VALUES (?,?,?,?,?,?,?)");
            $stmt->execute([$name, $emp_id, $email, $hashed, $department, $phone, $role]);
            $msg = "কর্মচারী সফলভাবে যোগ করা হয়েছে!";
        } catch (Exception $e) {
            $error = "এই Employee ID বা Email ইতিমধ্যে আছে!";
        }
    } else {
        $error = "সব তথ্য পূরণ করুন।";
    }
}

// Delete employee
if (isset($_GET['delete'])) {
    $del_id = (int)$_GET['delete'];
    if ($del_id !== $_SESSION['employee_id']) {
        $db->prepare("UPDATE employees SET status='inactive' WHERE id=?")->execute([$del_id]);
        $msg = "কর্মচারী নিষ্ক্রিয় করা হয়েছে।";
    }
}

// Reset password
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'reset_pass') {
    $emp_id_reset = (int)$_POST['emp_id_reset'];
    $new_pass = $_POST['new_password'];
    if ($emp_id_reset && $new_pass) {
        $hashed = password_hash($new_pass, PASSWORD_DEFAULT);
        $db->prepare("UPDATE employees SET password=? WHERE id=?")->execute([$hashed, $emp_id_reset]);
        $msg = "পাসওয়ার্ড পরিবর্তন করা হয়েছে।";
    }
}

$employees = $db->query("SELECT * FROM employees ORDER BY role, name")->fetchAll();
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>কর্মচারী ব্যবস্থাপনা</title>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { margin:0; padding:0; box-sizing:border-box; }
        :root { --primary:#1a6b3a; --primary-light:#2d9e5c; --bg:#0a1f12; --surface:#0f2d1a; --surface2:#1a3d24; --text:#e8f5e9; --text-muted:#81c784; --border:#2d6b3a; }
        body { font-family:'Hind Siliguri',sans-serif; background:var(--bg); color:var(--text); min-height:100vh; padding-bottom:40px; }
        
        .header { background:linear-gradient(135deg,#0f4525,var(--surface)); padding:16px 20px; display:flex; justify-content:space-between; align-items:center; border-bottom:1px solid var(--border); }
        .header h1 { font-size:20px; }
        .back-btn { color:var(--text-muted); text-decoration:none; font-size:14px; display:flex; align-items:center; gap:6px; }
        
        .content { padding:20px; max-width:900px; margin:0 auto; }
        
        .card { background:var(--surface); border:1px solid var(--border); border-radius:18px; padding:20px; margin-bottom:20px; }
        .card-title { font-size:16px; font-weight:700; margin-bottom:16px; display:flex; align-items:center; gap:8px; }
        
        .form-grid { display:grid; grid-template-columns:1fr 1fr; gap:12px; }
        @media(max-width:500px) { .form-grid { grid-template-columns:1fr; } }
        
        .form-group { margin-bottom:0; }
        .form-group label { display:block; font-size:13px; color:var(--text-muted); margin-bottom:6px; }
        .form-group input, .form-group select {
            width:100%; background:var(--surface2); border:1.5px solid var(--border); border-radius:10px;
            padding:10px 14px; color:var(--text); font-family:'Hind Siliguri',sans-serif; font-size:14px; outline:none;
        }
        .form-group input:focus { border-color:var(--primary-light); }
        
        .btn { padding:12px 24px; border:none; border-radius:10px; font-family:'Hind Siliguri',sans-serif; font-size:15px; font-weight:600; cursor:pointer; transition:all 0.2s; }
        .btn-primary { background:linear-gradient(135deg,var(--primary-light),var(--primary)); color:white; }
        .btn-danger { background:rgba(239,83,80,0.15); color:#ef9a9a; border:1px solid rgba(239,83,80,0.3); font-size:12px; padding:6px 12px; }
        .btn-info { background:rgba(66,165,245,0.15); color:#42a5f5; border:1px solid rgba(66,165,245,0.3); font-size:12px; padding:6px 12px; }
        
        .alert-success { background:rgba(102,187,106,0.1); border:1px solid rgba(102,187,106,0.3); color:#a5d6a7; padding:12px 16px; border-radius:10px; margin-bottom:16px; }
        .alert-error { background:rgba(239,83,80,0.1); border:1px solid rgba(239,83,80,0.3); color:#ef9a9a; padding:12px 16px; border-radius:10px; margin-bottom:16px; }
        
        table { width:100%; border-collapse:collapse; }
        th { background:var(--surface2); padding:12px 14px; text-align:left; font-size:13px; color:var(--text-muted); }
        td { padding:12px 14px; font-size:13px; border-bottom:1px solid rgba(45,107,58,0.2); }
        tr:last-child td { border-bottom:none; }
        
        .badge-admin { background:rgba(244,196,48,0.2); color:#f4c430; padding:3px 10px; border-radius:20px; font-size:11px; }
        .badge-emp { background:rgba(66,165,245,0.2); color:#42a5f5; padding:3px 10px; border-radius:20px; font-size:11px; }
        .badge-inactive { background:rgba(239,83,80,0.15); color:#ef9a9a; padding:3px 10px; border-radius:20px; font-size:11px; }
        
        .modal { display:none; position:fixed; inset:0; background:rgba(0,0,0,0.7); z-index:999; align-items:center; justify-content:center; padding:20px; }
        .modal.show { display:flex; }
        .modal-box { background:var(--surface); border:1px solid var(--border); border-radius:16px; padding:24px; width:100%; max-width:360px; }
        .modal-title { font-size:16px; font-weight:700; margin-bottom:16px; }

        @media(max-width:600px) { th:nth-child(3), td:nth-child(3) { display:none; } }
    </style>
</head>
<body>
<div class="header">
    <h1>👥 কর্মচারী ব্যবস্থাপনা</h1>
    <a href="admin.php" class="back-btn">← ড্যাশবোর্ড</a>
</div>

<div class="content">

    <?php if ($msg): ?><div class="alert-success">✅ <?= $msg ?></div><?php endif; ?>
    <?php if ($error): ?><div class="alert-error">❌ <?= $error ?></div><?php endif; ?>

    <!-- Add Employee -->
    <div class="card">
        <div class="card-title">➕ নতুন কর্মচারী যোগ করুন</div>
        <form method="POST">
            <input type="hidden" name="action" value="add">
            <div class="form-grid">
                <div class="form-group"><label>পূর্ণ নাম *</label><input type="text" name="name" placeholder="নাম লিখুন" required></div>
                <div class="form-group"><label>Employee ID *</label><input type="text" name="emp_id" placeholder="EMP004" required></div>
                <div class="form-group"><label>ইমেইল *</label><input type="email" name="email" placeholder="email@company.com" required></div>
                <div class="form-group"><label>পাসওয়ার্ড *</label><input type="password" name="password" placeholder="পাসওয়ার্ড" required></div>
                <div class="form-group"><label>বিভাগ</label><input type="text" name="department" placeholder="Sales, IT, HR..."></div>
                <div class="form-group"><label>ফোন নম্বর</label><input type="text" name="phone" placeholder="01XXXXXXXXX"></div>
                <div class="form-group"><label>ভূমিকা</label>
                    <select name="role">
                        <option value="employee">Employee</option>
                        <option value="admin">Admin</option>
                    </select>
                </div>
            </div>
            <div style="margin-top:16px">
                <button type="submit" class="btn btn-primary">✅ কর্মচারী যোগ করুন</button>
            </div>
        </form>
    </div>

    <!-- Employees List -->
    <div class="card">
        <div class="card-title">📋 কর্মচারী তালিকা (<?= count($employees) ?>)</div>
        <div style="overflow-x:auto">
            <table>
                <thead>
                    <tr>
                        <th>নাম</th>
                        <th>ID</th>
                        <th>বিভাগ</th>
                        <th>ভূমিকা</th>
                        <th>অ্যাকশন</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($employees as $e): ?>
                    <tr>
                        <td>
                            <div style="font-weight:600"><?= htmlspecialchars($e['name']) ?></div>
                            <div style="font-size:11px;color:var(--text-muted)"><?= htmlspecialchars($e['email']) ?></div>
                        </td>
                        <td><?= htmlspecialchars($e['employee_id']) ?></td>
                        <td><?= htmlspecialchars($e['department'] ?? '—') ?></td>
                        <td>
                            <span class="badge-<?= $e['status'] === 'inactive' ? 'inactive' : ($e['role'] === 'admin' ? 'admin' : 'emp') ?>">
                                <?= $e['status'] === 'inactive' ? 'নিষ্ক্রিয়' : ($e['role'] === 'admin' ? 'Admin' : 'Employee') ?>
                            </span>
                        </td>
                        <td>
                            <div style="display:flex;gap:6px;flex-wrap:wrap">
                                <?php if ($e['id'] !== $_SESSION['employee_id'] && $e['status'] === 'active'): ?>
                                <a href="?delete=<?= $e['id'] ?>" class="btn btn-danger" onclick="return confirm('নিষ্ক্রিয় করবেন?')">🚫 নিষ্ক্রিয়</a>
                                <?php endif; ?>
                                <button class="btn btn-info" onclick="showResetModal(<?= $e['id'] ?>, '<?= htmlspecialchars($e['name']) ?>')">🔑 পাস রিসেট</button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

</div>

<!-- Password Reset Modal -->
<div class="modal" id="resetModal">
    <div class="modal-box">
        <div class="modal-title">🔑 পাসওয়ার্ড রিসেট</div>
        <form method="POST">
            <input type="hidden" name="action" value="reset_pass">
            <input type="hidden" name="emp_id_reset" id="resetEmpId">
            <p id="resetEmpName" style="color:var(--text-muted);margin-bottom:16px;font-size:14px"></p>
            <div class="form-group" style="margin-bottom:16px">
                <label>নতুন পাসওয়ার্ড</label>
                <input type="password" name="new_password" placeholder="নতুন পাসওয়ার্ড দিন" required>
            </div>
            <div style="display:flex;gap:10px">
                <button type="submit" class="btn btn-primary" style="flex:1">✅ পরিবর্তন করুন</button>
                <button type="button" class="btn btn-danger" onclick="closeResetModal()">বাতিল</button>
            </div>
        </form>
    </div>
</div>

<script>
function showResetModal(id, name) {
    document.getElementById('resetEmpId').value = id;
    document.getElementById('resetEmpName').textContent = 'কর্মচারী: ' + name;
    document.getElementById('resetModal').classList.add('show');
}
function closeResetModal() {
    document.getElementById('resetModal').classList.remove('show');
}
</script>
</body>
</html>
