<?php
require_once '../config.php';
header('Content-Type: application/json');

if (!isset($_SESSION['employee_id'])) {
    echo json_encode(['success' => false, 'message' => 'অনুমতি নেই']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
    exit;
}

$db = getDB();
$emp_id = $_SESSION['employee_id'];
$action = $_POST['action'] ?? '';
$photo_data = $_POST['photo'] ?? '';
$lat = !empty($_POST['lat']) ? (float)$_POST['lat'] : null;
$lng = !empty($_POST['lng']) ? (float)$_POST['lng'] : null;
$address = sanitize($_POST['address'] ?? '');
$today = date('Y-m-d');
$now = date('Y-m-d H:i:s');

// Save photo
$photo_filename = null;
if (!empty($photo_data) && strpos($photo_data, 'data:image') === 0) {
    $photo_data_clean = preg_replace('#^data:image/\w+;base64,#i', '', $photo_data);
    $photo_decoded = base64_decode($photo_data_clean);
    
    if ($photo_decoded) {
        $photo_filename = $emp_id . '_' . $action . '_' . date('YmdHis') . '.jpg';
        $upload_dir = __DIR__ . '/../uploads/photos/';
        
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0755, true);
        }
        
        file_put_contents($upload_dir . $photo_filename, $photo_decoded);
    }
}

if ($action === 'checkin') {
    // Check if already checked in today
    $stmt = $db->prepare("SELECT id FROM attendance WHERE employee_id = ? AND date = ?");
    $stmt->execute([$emp_id, $today]);
    
    if ($stmt->fetch()) {
        echo json_encode(['success' => false, 'message' => 'আজ ইতিমধ্যে চেক ইন করেছেন!']);
        exit;
    }
    
    // Determine status (late if after 9 AM)
    $check_in_hour = (int)date('H');
    $check_in_min = (int)date('i');
    $status = ($check_in_hour > 9 || ($check_in_hour === 9 && $check_in_min > 0)) ? 'late' : 'present';
    
    $stmt = $db->prepare("INSERT INTO attendance (employee_id, date, check_in_time, check_in_photo, check_in_lat, check_in_lng, check_in_address, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$emp_id, $today, $now, $photo_filename, $lat, $lng, $address, $status]);
    
    echo json_encode(['success' => true, 'message' => 'সফলভাবে চেক ইন হয়েছে! ' . date('h:i A')]);
    
} elseif ($action === 'checkout') {
    // Check if checked in
    $stmt = $db->prepare("SELECT id, check_out_time FROM attendance WHERE employee_id = ? AND date = ?");
    $stmt->execute([$emp_id, $today]);
    $att = $stmt->fetch();
    
    if (!$att) {
        echo json_encode(['success' => false, 'message' => 'আগে চেক ইন করুন!']);
        exit;
    }
    
    if ($att['check_out_time']) {
        echo json_encode(['success' => false, 'message' => 'ইতিমধ্যে চেক আউট করেছেন!']);
        exit;
    }
    
    $stmt = $db->prepare("UPDATE attendance SET check_out_time = ?, check_out_photo = ?, check_out_lat = ?, check_out_lng = ?, check_out_address = ? WHERE employee_id = ? AND date = ?");
    $stmt->execute([$now, $photo_filename, $lat, $lng, $address, $emp_id, $today]);
    
    echo json_encode(['success' => true, 'message' => 'সফলভাবে চেক আউট হয়েছে! ' . date('h:i A')]);
    
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid action']);
}
?>
