<?php
// Database Configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'root');        // আপনার MySQL username
define('DB_PASS', '');            // আপনার MySQL password
define('DB_NAME', 'attendance_db');

// App Configuration
define('APP_NAME', 'উপস্থিতি ট্র্যাকার');
define('APP_URL', 'http://localhost/attendance');  // আপনার URL দিন
define('UPLOAD_PATH', __DIR__ . '/uploads/photos/');
define('UPLOAD_URL', APP_URL . '/uploads/photos/');

// Session start
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Database connection
function getDB() {
    static $pdo = null;
    if ($pdo === null) {
        try {
            $pdo = new PDO(
                "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
                DB_USER,
                DB_PASS,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
        } catch (PDOException $e) {
            die(json_encode(['success' => false, 'message' => 'Database connection failed: ' . $e->getMessage()]));
        }
    }
    return $pdo;
}

// Auth check
function requireLogin() {
    if (!isset($_SESSION['employee_id'])) {
        header('Location: index.php');
        exit;
    }
}

function requireAdmin() {
    requireLogin();
    if ($_SESSION['role'] !== 'admin') {
        header('Location: dashboard.php');
        exit;
    }
}

// Helper functions
function sanitize($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

function formatTime($datetime) {
    if (!$datetime) return '--';
    return date('h:i A', strtotime($datetime));
}

function formatDate($date) {
    if (!$date) return '--';
    $months = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
    $d = date('d', strtotime($date));
    $m = $months[date('n', strtotime($date)) - 1];
    $y = date('Y', strtotime($date));
    return "$d $m $y";
}
?>
