<?php
require_once 'config.php';
requireLogin();

$db = getDB();
$emp_db_id = $_SESSION['employee_id'];
$today = date('Y-m-d');

// Get today's attendance
$stmt = $db->prepare("SELECT * FROM attendance WHERE employee_id = ? AND date = ?");
$stmt->execute([$emp_db_id, $today]);
$today_att = $stmt->fetch();

// Get recent attendance (last 7 days)
$stmt = $db->prepare("SELECT * FROM attendance WHERE employee_id = ? ORDER BY date DESC LIMIT 10");
$stmt->execute([$emp_db_id]);
$recent = $stmt->fetchAll();

// Get this month stats
$month_start = date('Y-m-01');
$stmt = $db->prepare("SELECT COUNT(*) as present FROM attendance WHERE employee_id = ? AND date >= ? AND date <= ?");
$stmt->execute([$emp_db_id, $month_start, $today]);
$month_stats = $stmt->fetch();
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>ড্যাশবোর্ড - উপস্থিতি ট্র্যাকার</title>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        :root {
            --primary: #1a6b3a;
            --primary-dark: #0f4525;
            --primary-light: #2d9e5c;
            --accent: #f4c430;
            --bg: #0a1f12;
            --surface: #0f2d1a;
            --surface2: #1a3d24;
            --text: #e8f5e9;
            --text-muted: #81c784;
            --error: #ef5350;
            --success: #66bb6a;
            --border: #2d6b3a;
            --orange: #ff7043;
        }

        body {
            font-family: 'Hind Siliguri', sans-serif;
            background: var(--bg);
            color: var(--text);
            min-height: 100vh;
            padding-bottom: 80px;
        }

        /* Header */
        .header {
            background: linear-gradient(135deg, var(--primary-dark), var(--surface));
            padding: 16px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 1px solid var(--border);
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .header-left h2 { font-size: 18px; font-weight: 700; }
        .header-left p { font-size: 12px; color: var(--text-muted); margin-top: 2px; }

        .logout-btn {
            background: rgba(239,83,80,0.15);
            border: 1px solid rgba(239,83,80,0.3);
            color: #ef9a9a;
            padding: 8px 14px;
            border-radius: 10px;
            font-family: 'Hind Siliguri', sans-serif;
            font-size: 13px;
            cursor: pointer;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .content { padding: 20px; max-width: 480px; margin: 0 auto; }

        /* Date/Time widget */
        .datetime-card {
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            border-radius: 20px;
            padding: 24px;
            text-align: center;
            margin-bottom: 20px;
            position: relative;
            overflow: hidden;
        }

        .datetime-card::before {
            content: '';
            position: absolute;
            top: -30px; right: -30px;
            width: 120px; height: 120px;
            background: rgba(255,255,255,0.05);
            border-radius: 50%;
        }

        .current-time {
            font-size: 48px;
            font-weight: 700;
            letter-spacing: 2px;
            line-height: 1;
        }

        .current-date {
            font-size: 16px;
            color: rgba(255,255,255,0.8);
            margin-top: 8px;
        }

        /* Status Badge */
        .status-badge {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 6px 16px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: 600;
            margin-top: 12px;
        }

        .status-badge.not-checked { background: rgba(244,196,48,0.2); color: #f4c430; border: 1px solid rgba(244,196,48,0.3); }
        .status-badge.checked-in { background: rgba(102,187,106,0.2); color: #66bb6a; border: 1px solid rgba(102,187,106,0.3); }
        .status-badge.checked-out { background: rgba(144,164,174,0.2); color: #b0bec5; border: 1px solid rgba(144,164,174,0.3); }

        /* Stats row */
        .stats-row {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 12px;
            margin-bottom: 20px;
        }

        .stat-card {
            background: var(--surface);
            border: 1px solid var(--border);
            border-radius: 14px;
            padding: 14px;
            text-align: center;
        }

        .stat-num { font-size: 24px; font-weight: 700; color: var(--primary-light); }
        .stat-label { font-size: 11px; color: var(--text-muted); margin-top: 4px; }

        /* Check In/Out Section */
        .attendance-section {
            background: var(--surface);
            border: 1px solid var(--border);
            border-radius: 20px;
            padding: 20px;
            margin-bottom: 20px;
        }

        .section-title {
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 16px;
            color: var(--text);
            display: flex;
            align-items: center;
            gap: 8px;
        }

        /* Today's info row */
        .time-info-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
            margin-bottom: 20px;
        }

        .time-box {
            background: var(--surface2);
            border-radius: 12px;
            padding: 14px;
            text-align: center;
        }

        .time-box-label { font-size: 11px; color: var(--text-muted); margin-bottom: 6px; }
        .time-box-value { font-size: 20px; font-weight: 700; }
        .time-box-value.checkin { color: var(--success); }
        .time-box-value.checkout { color: var(--orange); }

        /* Camera/Location area */
        .capture-area {
            margin-bottom: 16px;
        }

        .camera-preview {
            width: 100%;
            border-radius: 14px;
            background: #000;
            aspect-ratio: 4/3;
            display: none;
            overflow: hidden;
            position: relative;
        }

        .camera-preview video,
        .camera-preview canvas {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .camera-preview canvas { display: none; position: absolute; top: 0; left: 0; }

        .captured-photo {
            width: 100%;
            border-radius: 14px;
            display: none;
            margin-bottom: 12px;
        }

        .captured-photo img {
            width: 100%;
            border-radius: 14px;
            border: 2px solid var(--success);
        }

        .camera-controls {
            display: flex;
            gap: 10px;
            margin-top: 10px;
        }

        .btn-cam {
            flex: 1;
            padding: 12px;
            border-radius: 12px;
            border: none;
            font-family: 'Hind Siliguri', sans-serif;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
        }

        .btn-open-cam { background: var(--surface2); color: var(--text); border: 1px solid var(--border); }
        .btn-capture { background: linear-gradient(135deg, var(--primary-light), var(--primary)); color: white; }
        .btn-retake { background: rgba(239,83,80,0.15); color: #ef9a9a; border: 1px solid rgba(239,83,80,0.3); }

        .cam-type-toggle {
            display: flex;
            gap: 8px;
            margin-bottom: 10px;
        }

        .cam-type-btn {
            flex: 1;
            padding: 8px;
            border-radius: 10px;
            border: 1px solid var(--border);
            background: var(--surface2);
            color: var(--text-muted);
            font-family: 'Hind Siliguri', sans-serif;
            font-size: 13px;
            cursor: pointer;
            transition: all 0.2s;
        }

        .cam-type-btn.active {
            background: var(--primary);
            border-color: var(--primary-light);
            color: white;
        }

        /* GPS info */
        .gps-info {
            background: var(--surface2);
            border-radius: 12px;
            padding: 14px;
            margin-bottom: 16px;
        }

        .gps-row {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .gps-status { font-size: 13px; color: var(--text-muted); }
        .gps-coords { font-size: 12px; color: var(--primary-light); margin-top: 4px; }

        .btn-get-gps {
            background: linear-gradient(135deg, #1565c0, #0d47a1);
            color: white;
            border: none;
            border-radius: 10px;
            padding: 10px 16px;
            font-family: 'Hind Siliguri', sans-serif;
            font-size: 14px;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 6px;
            white-space: nowrap;
        }

        /* Submit button */
        .btn-submit {
            width: 100%;
            padding: 18px;
            border-radius: 14px;
            border: none;
            font-family: 'Hind Siliguri', sans-serif;
            font-size: 20px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }

        .btn-checkin { background: linear-gradient(135deg, #2d9e5c, #1a6b3a); color: white; box-shadow: 0 6px 20px rgba(26,107,58,0.4); }
        .btn-checkout { background: linear-gradient(135deg, #ff7043, #e64a19); color: white; box-shadow: 0 6px 20px rgba(230,74,25,0.4); }
        .btn-disabled { background: var(--surface2); color: var(--text-muted); cursor: not-allowed; }

        .btn-submit:not(.btn-disabled):hover { transform: translateY(-2px); }

        /* Map link */
        .map-link {
            display: inline-flex;
            align-items: center;
            gap: 4px;
            color: var(--primary-light);
            font-size: 12px;
            text-decoration: none;
            margin-top: 4px;
        }

        /* Recent attendance */
        .recent-section {
            background: var(--surface);
            border: 1px solid var(--border);
            border-radius: 20px;
            padding: 20px;
        }

        .att-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 12px 0;
            border-bottom: 1px solid rgba(45,107,58,0.3);
        }

        .att-item:last-child { border-bottom: none; }
        .att-date { font-size: 14px; font-weight: 500; }
        .att-date small { display: block; font-size: 11px; color: var(--text-muted); }
        .att-times { text-align: right; font-size: 13px; }
        .att-times span { color: var(--text-muted); font-size: 11px; }

        .badge { padding: 3px 10px; border-radius: 20px; font-size: 11px; font-weight: 600; }
        .badge-present { background: rgba(102,187,106,0.2); color: #66bb6a; }
        .badge-late { background: rgba(255,112,67,0.2); color: #ff7043; }
        .badge-half { background: rgba(244,196,48,0.2); color: #f4c430; }

        /* Alert */
        .alert {
            padding: 14px 16px;
            border-radius: 12px;
            margin-bottom: 16px;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        .alert-success { background: rgba(102,187,106,0.1); border: 1px solid rgba(102,187,106,0.3); color: #a5d6a7; }
        .alert-error { background: rgba(239,83,80,0.1); border: 1px solid rgba(239,83,80,0.3); color: #ef9a9a; }

        /* Loading overlay */
        .loading-overlay {
            display: none;
            position: fixed;
            inset: 0;
            background: rgba(0,0,0,0.7);
            z-index: 999;
            align-items: center;
            justify-content: center;
            flex-direction: column;
            gap: 16px;
        }

        .loading-overlay.show { display: flex; }

        .spinner {
            width: 48px;
            height: 48px;
            border: 4px solid var(--border);
            border-top-color: var(--primary-light);
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
        }

        @keyframes spin { to { transform: rotate(360deg); } }
    </style>
</head>
<body>

<div class="loading-overlay" id="loadingOverlay">
    <div class="spinner"></div>
    <p style="color: var(--text);">প্রক্রিয়া হচ্ছে...</p>
</div>

<div class="header">
    <div class="header-left">
        <h2>👋 <?= htmlspecialchars($_SESSION['name']) ?></h2>
        <p><?= htmlspecialchars($_SESSION['emp_id']) ?> • <?= htmlspecialchars($_SESSION['department'] ?? '') ?></p>
    </div>
    <a href="logout.php" class="logout-btn">🚪 লগআউট</a>
</div>

<div class="content">

    <?php if (isset($_GET['success'])): ?>
    <div class="alert alert-success">✅ <?= sanitize($_GET['success']) ?></div>
    <?php endif; ?>
    <?php if (isset($_GET['error'])): ?>
    <div class="alert alert-error">❌ <?= sanitize($_GET['error']) ?></div>
    <?php endif; ?>

    <!-- Date/Time Card -->
    <div class="datetime-card">
        <div class="current-time" id="currentTime">--:--:--</div>
        <div class="current-date" id="currentDate">--</div>
        <?php if (!$today_att): ?>
            <div class="status-badge not-checked">⏳ আজ এখনো চেক ইন করেননি</div>
        <?php elseif ($today_att && !$today_att['check_out_time']): ?>
            <div class="status-badge checked-in">✅ চেক ইন করা আছে</div>
        <?php else: ?>
            <div class="status-badge checked-out">🏠 আজকের কাজ শেষ</div>
        <?php endif; ?>
    </div>

    <!-- Stats -->
    <div class="stats-row">
        <div class="stat-card">
            <div class="stat-num"><?= $month_stats['present'] ?></div>
            <div class="stat-label">এই মাসে উপস্থিত</div>
        </div>
        <div class="stat-card">
            <div class="stat-num"><?= date('j') ?></div>
            <div class="stat-label">আজ তারিখ</div>
        </div>
        <div class="stat-card">
            <div class="stat-num"><?= count($recent) ?></div>
            <div class="stat-label">মোট রেকর্ড</div>
        </div>
    </div>

    <!-- Today's times -->
    <?php if ($today_att): ?>
    <div class="time-info-row">
        <div class="time-box">
            <div class="time-box-label">✅ চেক ইন</div>
            <div class="time-box-value checkin"><?= formatTime($today_att['check_in_time']) ?></div>
            <?php if ($today_att['check_in_lat']): ?>
            <a href="https://maps.google.com/?q=<?= $today_att['check_in_lat'] ?>,<?= $today_att['check_in_lng'] ?>" target="_blank" class="map-link">🗺️ ম্যাপে দেখুন</a>
            <?php endif; ?>
        </div>
        <div class="time-box">
            <div class="time-box-label">🔴 চেক আউট</div>
            <div class="time-box-value checkout"><?= $today_att['check_out_time'] ? formatTime($today_att['check_out_time']) : '--:--' ?></div>
            <?php if ($today_att['check_out_lat']): ?>
            <a href="https://maps.google.com/?q=<?= $today_att['check_out_lat'] ?>,<?= $today_att['check_out_lng'] ?>" target="_blank" class="map-link">🗺️ ম্যাপে দেখুন</a>
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Attendance Action -->
    <?php if (!$today_att || !$today_att['check_out_time']): ?>
    <div class="attendance-section">
        <div class="section-title">
            📸 <?= !$today_att ? 'চেক ইন করুন' : 'চেক আউট করুন' ?>
        </div>

        <!-- Camera type toggle -->
        <div class="cam-type-toggle">
            <button class="cam-type-btn active" id="btnFront" onclick="setCamType('front')">🤳 সামনের ক্যামেরা</button>
            <button class="cam-type-btn" id="btnBack" onclick="setCamType('back')">📷 পিছনের ক্যামেরা</button>
        </div>

        <!-- Camera preview -->
        <div class="capture-area">
            <div class="camera-preview" id="cameraPreview">
                <video id="videoEl" autoplay playsinline muted></video>
                <canvas id="canvasEl"></canvas>
            </div>

            <div class="captured-photo" id="capturedPhoto">
                <img id="capturedImg" src="" alt="Captured">
            </div>

            <div class="camera-controls">
                <button class="btn-cam btn-open-cam" id="btnOpenCam" onclick="openCamera()">📷 ক্যামেরা খুলুন</button>
                <button class="btn-cam btn-capture" id="btnCapture" onclick="capturePhoto()" style="display:none">📸 ছবি তুলুন</button>
                <button class="btn-cam btn-retake" id="btnRetake" onclick="retakePhoto()" style="display:none">🔄 আবার তুলুন</button>
            </div>
        </div>

        <!-- GPS -->
        <div class="gps-info">
            <div class="gps-row">
                <div style="flex:1">
                    <div class="gps-status" id="gpsStatus">📍 লোকেশন নেওয়া হয়নি</div>
                    <div class="gps-coords" id="gpsCoords"></div>
                </div>
                <button class="btn-get-gps" onclick="getLocation()">🗺️ লোকেশন নিন</button>
            </div>
        </div>

        <!-- Submit -->
        <button class="btn-submit <?= !$today_att ? 'btn-checkin' : 'btn-checkout' ?>" 
                id="btnSubmit" onclick="submitAttendance()">
            <?= !$today_att ? '✅ চেক ইন করুন' : '🔴 চেক আউট করুন' ?>
        </button>
    </div>
    <?php else: ?>
    <div class="attendance-section">
        <div style="text-align:center; padding: 20px;">
            <div style="font-size: 48px; margin-bottom: 12px;">🎉</div>
            <div style="font-size: 18px; font-weight: 600; margin-bottom: 8px;">আজকের কাজ সম্পন্ন!</div>
            <div style="color: var(--text-muted); font-size: 14px;">আপনি আজ সফলভাবে চেক ইন ও চেক আউট করেছেন।</div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Recent Attendance -->
    <div class="recent-section">
        <div class="section-title">📅 সাম্প্রতিক উপস্থিতি</div>
        <?php if (empty($recent)): ?>
            <p style="text-align:center; color: var(--text-muted); padding: 20px;">এখনো কোনো রেকর্ড নেই</p>
        <?php else: ?>
            <?php foreach ($recent as $r): ?>
            <div class="att-item">
                <div class="att-date">
                    <?= formatDate($r['date']) ?>
                    <small><?= date('l', strtotime($r['date'])) ?></small>
                </div>
                <div class="att-times">
                    <span>ইন: </span><?= formatTime($r['check_in_time']) ?><br>
                    <span>আউট: </span><?= $r['check_out_time'] ? formatTime($r['check_out_time']) : '--' ?>
                </div>
                <span class="badge badge-<?= $r['status'] === 'present' ? 'present' : ($r['status'] === 'late' ? 'late' : 'half') ?>">
                    <?= $r['status'] === 'present' ? 'উপস্থিত' : ($r['status'] === 'late' ? 'দেরি' : 'আধা দিন') ?>
                </span>
            </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

</div>

<input type="hidden" id="photoData" value="">
<input type="hidden" id="latData" value="">
<input type="hidden" id="lngData" value="">
<input type="hidden" id="addressData" value="">
<input type="hidden" id="actionType" value="<?= !$today_att ? 'checkin' : 'checkout' ?>">

<script>
let stream = null;
let currentCamType = 'front';
let locationObtained = false;
let photoTaken = false;

// Clock
function updateClock() {
    const now = new Date();
    const timeEl = document.getElementById('currentTime');
    const dateEl = document.getElementById('currentDate');
    
    if (timeEl) {
        timeEl.textContent = now.toLocaleTimeString('bn-BD', {hour: '2-digit', minute: '2-digit', second: '2-digit'});
    }
    
    if (dateEl) {
        dateEl.textContent = now.toLocaleDateString('bn-BD', {weekday: 'long', year: 'numeric', month: 'long', day: 'numeric'});
    }
}
setInterval(updateClock, 1000);
updateClock();

function setCamType(type) {
    currentCamType = type;
    document.getElementById('btnFront').classList.toggle('active', type === 'front');
    document.getElementById('btnBack').classList.toggle('active', type === 'back');
    
    if (stream) {
        stopCamera();
        openCamera();
    }
}

async function openCamera() {
    try {
        if (stream) stopCamera();
        
        const constraints = {
            video: {
                facingMode: currentCamType === 'front' ? 'user' : 'environment',
                width: { ideal: 640 },
                height: { ideal: 480 }
            }
        };
        
        stream = await navigator.mediaDevices.getUserMedia(constraints);
        const video = document.getElementById('videoEl');
        video.srcObject = stream;
        
        document.getElementById('cameraPreview').style.display = 'block';
        document.getElementById('capturedPhoto').style.display = 'none';
        document.getElementById('btnOpenCam').style.display = 'none';
        document.getElementById('btnCapture').style.display = 'flex';
        document.getElementById('btnRetake').style.display = 'none';
        
        photoTaken = false;
        document.getElementById('photoData').value = '';
        
    } catch (err) {
        alert('ক্যামেরা অ্যাক্সেস করতে পারছে না। অনুমতি দিন।\n' + err.message);
    }
}

function stopCamera() {
    if (stream) {
        stream.getTracks().forEach(t => t.stop());
        stream = null;
    }
}

function capturePhoto() {
    const video = document.getElementById('videoEl');
    const canvas = document.getElementById('canvasEl');
    
    canvas.width = video.videoWidth;
    canvas.height = video.videoHeight;
    
    const ctx = canvas.getContext('2d');
    if (currentCamType === 'front') {
        ctx.translate(canvas.width, 0);
        ctx.scale(-1, 1);
    }
    ctx.drawImage(video, 0, 0);
    
    const photoData = canvas.toDataURL('image/jpeg', 0.8);
    document.getElementById('photoData').value = photoData;
    document.getElementById('capturedImg').src = photoData;
    
    document.getElementById('cameraPreview').style.display = 'none';
    document.getElementById('capturedPhoto').style.display = 'block';
    document.getElementById('btnCapture').style.display = 'none';
    document.getElementById('btnRetake').style.display = 'flex';
    
    stopCamera();
    photoTaken = true;
}

function retakePhoto() {
    photoTaken = false;
    document.getElementById('photoData').value = '';
    document.getElementById('capturedPhoto').style.display = 'none';
    document.getElementById('btnRetake').style.display = 'none';
    document.getElementById('btnOpenCam').style.display = 'flex';
}

function getLocation() {
    const statusEl = document.getElementById('gpsStatus');
    const coordsEl = document.getElementById('gpsCoords');
    
    statusEl.textContent = '⏳ লোকেশন খোঁজা হচ্ছে...';
    
    if (!navigator.geolocation) {
        statusEl.textContent = '❌ এই ডিভাইসে GPS নেই';
        return;
    }
    
    navigator.geolocation.getCurrentPosition(
        async (pos) => {
            const lat = pos.coords.latitude;
            const lng = pos.coords.longitude;
            
            document.getElementById('latData').value = lat;
            document.getElementById('lngData').value = lng;
            
            statusEl.textContent = '✅ লোকেশন পাওয়া গেছে';
            coordsEl.textContent = `${lat.toFixed(6)}, ${lng.toFixed(6)}`;
            
            locationObtained = true;
            
            // Try reverse geocoding
            try {
                const res = await fetch(`https://nominatim.openstreetmap.org/reverse?lat=${lat}&lon=${lng}&format=json`);
                const data = await res.json();
                if (data.display_name) {
                    const shortAddr = data.display_name.split(',').slice(0,3).join(',');
                    document.getElementById('addressData').value = data.display_name;
                    coordsEl.textContent = shortAddr;
                }
            } catch(e) {}
        },
        (err) => {
            statusEl.textContent = '❌ লোকেশন পাওয়া যায়নি - ' + err.message;
        },
        { enableHighAccuracy: true, timeout: 10000, maximumAge: 0 }
    );
}

async function submitAttendance() {
    if (!photoTaken) {
        alert('প্রথমে ছবি তুলুন!');
        return;
    }
    
    if (!locationObtained) {
        if (!confirm('লোকেশন ছাড়া জমা দিতে চান?')) return;
    }
    
    document.getElementById('loadingOverlay').classList.add('show');
    
    const formData = new FormData();
    formData.append('action', document.getElementById('actionType').value);
    formData.append('photo', document.getElementById('photoData').value);
    formData.append('lat', document.getElementById('latData').value);
    formData.append('lng', document.getElementById('lngData').value);
    formData.append('address', document.getElementById('addressData').value);
    
    try {
        const res = await fetch('api/attendance.php', { method: 'POST', body: formData });
        const data = await res.json();
        
        if (data.success) {
            window.location.href = 'dashboard.php?success=' + encodeURIComponent(data.message);
        } else {
            document.getElementById('loadingOverlay').classList.remove('show');
            alert('❌ ' + data.message);
        }
    } catch (e) {
        document.getElementById('loadingOverlay').classList.remove('show');
        alert('সংযোগ সমস্যা! আবার চেষ্টা করুন।');
    }
}

// Auto get location on load
window.addEventListener('load', () => {
    setTimeout(getLocation, 500);
});
</script>
</body>
</html>
