-- Attendance System Database
CREATE DATABASE IF NOT EXISTS attendance_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE attendance_db;

CREATE TABLE IF NOT EXISTS employees (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    employee_id VARCHAR(20) UNIQUE NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    department VARCHAR(100),
    phone VARCHAR(20),
    profile_photo VARCHAR(255),
    role ENUM('employee','admin') DEFAULT 'employee',
    status ENUM('active','inactive') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS attendance (
    id INT AUTO_INCREMENT PRIMARY KEY,
    employee_id INT NOT NULL,
    date DATE NOT NULL,
    check_in_time DATETIME,
    check_in_photo VARCHAR(255),
    check_in_lat DECIMAL(10,8),
    check_in_lng DECIMAL(11,8),
    check_in_address TEXT,
    check_out_time DATETIME,
    check_out_photo VARCHAR(255),
    check_out_lat DECIMAL(10,8),
    check_out_lng DECIMAL(11,8),
    check_out_address TEXT,
    status ENUM('present','absent','half_day','late') DEFAULT 'present',
    notes TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (employee_id) REFERENCES employees(id),
    UNIQUE KEY unique_attendance (employee_id, date)
);

-- Default admin account (password: admin123)
INSERT INTO employees (name, employee_id, email, password, department, role) VALUES
('Admin User', 'ADMIN001', 'admin@company.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Administration', 'admin');

-- Sample employees (password: 123456)
INSERT INTO employees (name, employee_id, email, password, department) VALUES
('রাহেলা বেগম', 'EMP001', 'rahela@company.com', '$2y$10$TKh8H1.PtIK1.P.Vo.2aqeOE3hVQr4kLBW7UxDAEo4I4.aGgQ9Fi2', 'Sales'),
('করিম হোসেন', 'EMP002', 'karim@company.com', '$2y$10$TKh8H1.PtIK1.P.Vo.2aqeOE3hVQr4kLBW7UxDAEo4I4.aGgQ9Fi2', 'IT'),
('সুমাইয়া আক্তার', 'EMP003', 'sumaiya@company.com', '$2y$10$TKh8H1.PtIK1.P.Vo.2aqeOE3hVQr4kLBW7UxDAEo4I4.aGgQ9Fi2', 'HR');
