<?php
require_once 'config.php';
requireAdmin();

$db = getDB();
$date = $_GET['date'] ?? date('Y-m-d');
$dept = $_GET['dept'] ?? '';

$query = "SELECT e.name, e.employee_id, e.department, 
          a.date, a.check_in_time, a.check_out_time,
          a.check_in_address, a.check_out_address,
          a.check_in_lat, a.check_in_lng,
          a.check_out_lat, a.check_out_lng, a.status
          FROM employees e
          LEFT JOIN attendance a ON e.id = a.employee_id AND a.date = ?
          WHERE e.status = 'active' AND e.role = 'employee'";
$params = [$date];

if ($dept) { $query .= " AND e.department = ?"; $params[] = $dept; }
$query .= " ORDER BY e.name";

$stmt = $db->prepare($query);
$stmt->execute($params);
$rows = $stmt->fetchAll();

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="attendance_' . $date . '.csv"');

$out = fopen('php://output', 'w');
fprintf($out, chr(0xEF).chr(0xBB).chr(0xBF)); // UTF-8 BOM

fputcsv($out, ['নাম','Employee ID','বিভাগ','তারিখ','চেক ইন','চেক আউট','ইন ঠিকানা','আউট ঠিকানা','ইন GPS','আউট GPS','স্ট্যাটাস']);

foreach ($rows as $r) {
    fputcsv($out, [
        $r['name'],
        $r['employee_id'],
        $r['department'],
        $r['date'] ?? $date,
        $r['check_in_time'] ? date('h:i A', strtotime($r['check_in_time'])) : 'অনুপস্থিত',
        $r['check_out_time'] ? date('h:i A', strtotime($r['check_out_time'])) : '—',
        $r['check_in_address'] ?? '—',
        $r['check_out_address'] ?? '—',
        $r['check_in_lat'] ? $r['check_in_lat'].','.$r['check_in_lng'] : '—',
        $r['check_out_lat'] ? $r['check_out_lat'].','.$r['check_out_lng'] : '—',
        $r['status'] ?? 'অনুপস্থিত'
    ]);
}

fclose($out);
?>
