<?php
require_once 'config.php';

// Already logged in
if (isset($_SESSION['employee_id'])) {
    header('Location: ' . ($_SESSION['role'] === 'admin' ? 'admin.php' : 'dashboard.php'));
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $employee_id = sanitize($_POST['employee_id'] ?? '');
    $password = $_POST['password'] ?? '';

    if ($employee_id && $password) {
        try {
            $db = getDB();
            $stmt = $db->prepare("SELECT * FROM employees WHERE (employee_id = ? OR email = ?) AND status = 'active'");
            $stmt->execute([$employee_id, $employee_id]);
            $employee = $stmt->fetch();

            if ($employee && password_verify($password, $employee['password'])) {
                $_SESSION['employee_id'] = $employee['id'];
                $_SESSION['name'] = $employee['name'];
                $_SESSION['emp_id'] = $employee['employee_id'];
                $_SESSION['role'] = $employee['role'];
                $_SESSION['department'] = $employee['department'];

                header('Location: ' . ($employee['role'] === 'admin' ? 'admin.php' : 'dashboard.php'));
                exit;
            } else {
                $error = 'Employee ID বা Password ভুল!';
            }
        } catch (Exception $e) {
            $error = 'সংযোগ সমস্যা হয়েছে। আবার চেষ্টা করুন।';
        }
    } else {
        $error = 'সব তথ্য পূরণ করুন।';
    }
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <title>লগইন - উপস্থিতি ট্র্যাকার</title>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        :root {
            --primary: #1a6b3a;
            --primary-dark: #0f4525;
            --primary-light: #2d9e5c;
            --accent: #f4c430;
            --bg: #0a1f12;
            --surface: #0f2d1a;
            --surface2: #1a3d24;
            --text: #e8f5e9;
            --text-muted: #81c784;
            --error: #ef5350;
            --border: #2d6b3a;
        }

        body {
            font-family: 'Hind Siliguri', sans-serif;
            background: var(--bg);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            position: relative;
            overflow: hidden;
        }

        body::before {
            content: '';
            position: fixed;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(ellipse at 30% 20%, rgba(26,107,58,0.3) 0%, transparent 50%),
                        radial-gradient(ellipse at 70% 80%, rgba(15,69,37,0.4) 0%, transparent 50%);
            animation: bgPulse 8s ease-in-out infinite alternate;
        }

        @keyframes bgPulse {
            0% { transform: scale(1) rotate(0deg); }
            100% { transform: scale(1.1) rotate(5deg); }
        }

        .login-container {
            width: 100%;
            max-width: 420px;
            position: relative;
            z-index: 1;
        }

        .logo-area {
            text-align: center;
            margin-bottom: 32px;
            animation: fadeDown 0.6s ease;
        }

        .logo-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, var(--primary-light), var(--primary));
            border-radius: 24px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-size: 36px;
            margin-bottom: 16px;
            box-shadow: 0 8px 32px rgba(26,107,58,0.5);
        }

        .logo-area h1 {
            color: var(--text);
            font-size: 24px;
            font-weight: 700;
            letter-spacing: 0.5px;
        }

        .logo-area p {
            color: var(--text-muted);
            font-size: 14px;
            margin-top: 4px;
        }

        .card {
            background: var(--surface);
            border: 1px solid var(--border);
            border-radius: 20px;
            padding: 32px 28px;
            box-shadow: 0 24px 64px rgba(0,0,0,0.4);
            animation: fadeUp 0.6s ease 0.2s both;
        }

        @keyframes fadeDown {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @keyframes fadeUp {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            color: var(--text-muted);
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 8px;
        }

        .input-wrap {
            position: relative;
        }

        .input-icon {
            position: absolute;
            left: 14px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 18px;
            pointer-events: none;
        }

        input {
            width: 100%;
            background: var(--surface2);
            border: 1.5px solid var(--border);
            border-radius: 12px;
            padding: 14px 14px 14px 44px;
            color: var(--text);
            font-family: 'Hind Siliguri', sans-serif;
            font-size: 16px;
            transition: all 0.3s;
            outline: none;
        }

        input:focus {
            border-color: var(--primary-light);
            background: rgba(26,107,58,0.1);
            box-shadow: 0 0 0 3px rgba(45,158,92,0.15);
        }

        input::placeholder { color: #4a7a56; }

        .error-msg {
            background: rgba(239,83,80,0.1);
            border: 1px solid rgba(239,83,80,0.3);
            color: #ef9a9a;
            padding: 12px 16px;
            border-radius: 10px;
            font-size: 14px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .btn-login {
            width: 100%;
            background: linear-gradient(135deg, var(--primary-light), var(--primary));
            color: white;
            border: none;
            border-radius: 12px;
            padding: 16px;
            font-family: 'Hind Siliguri', sans-serif;
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            box-shadow: 0 4px 16px rgba(26,107,58,0.4);
            letter-spacing: 0.5px;
        }

        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 24px rgba(26,107,58,0.5);
        }

        .btn-login:active { transform: translateY(0); }

        .demo-info {
            margin-top: 24px;
            padding: 16px;
            background: rgba(244,196,48,0.08);
            border: 1px solid rgba(244,196,48,0.2);
            border-radius: 12px;
        }

        .demo-info p {
            color: #f4c430;
            font-size: 13px;
            font-weight: 600;
            margin-bottom: 8px;
        }

        .demo-info small {
            color: var(--text-muted);
            font-size: 12px;
            display: block;
            line-height: 1.8;
        }

        .toggle-pass {
            position: absolute;
            right: 14px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            font-size: 18px;
            color: var(--text-muted);
        }
    </style>
</head>
<body>
<div class="login-container">
    <div class="logo-area">
        <div class="logo-icon">📋</div>
        <h1>উপস্থিতি ট্র্যাকার</h1>
        <p>কর্মচারী হাজিরা ব্যবস্থাপনা সিস্টেম</p>
    </div>

    <div class="card">
        <?php if ($error): ?>
        <div class="error-msg">⚠️ <?= $error ?></div>
        <?php endif; ?>

        <form method="POST">
            <div class="form-group">
                <label>Employee ID অথবা Email</label>
                <div class="input-wrap">
                    <span class="input-icon">👤</span>
                    <input type="text" name="employee_id" placeholder="EMP001 বা email@company.com" 
                           value="<?= sanitize($_POST['employee_id'] ?? '') ?>" required>
                </div>
            </div>

            <div class="form-group">
                <label>পাসওয়ার্ড</label>
                <div class="input-wrap">
                    <span class="input-icon">🔒</span>
                    <input type="password" name="password" id="password" placeholder="আপনার পাসওয়ার্ড" required>
                    <span class="toggle-pass" onclick="togglePass()">👁️</span>
                </div>
            </div>

            <button type="submit" class="btn-login">লগইন করুন →</button>
        </form>

        <div class="demo-info">
            <p>🔑 ডেমো অ্যাকাউন্ট</p>
            <small>
                Admin: admin@company.com / admin123<br>
                Employee: EMP001 / 123456<br>
                Employee: EMP002 / 123456
            </small>
        </div>
    </div>
</div>

<script>
function togglePass() {
    const p = document.getElementById('password');
    p.type = p.type === 'password' ? 'text' : 'password';
}
</script>
</body>
</html>
